# 0  [Github](https://github.com/Wasabi1234)

# 1 面试题

- 有没有做过MySQL读写分离
- 如何实现MySQL的读写分离
- 主从复制原理
- 如何解决MySQL主从同步的延时问题

准备好面对这炮轰式面试了吗?

# 2 考点分析

高并发阶段,肯定需要做读写分离.

实际上大部分互联网公司/网站/APP,都是读多写少

针对现状,写一个主库,挂着多个从库,然后从多个从库来读,那不就可以支撑更高的读并发压力了吗？

# 3 MySQL读写分离的实现

基于主从复制架构

搞一个主库,挂多个从库,然后就单单只是写主库,接着主库会自动将数据同步到从库

# 4 MySQL主从复制的原理

- 为什么MySQL要读写分离？
![](https://ask.qcloudimg.com/http-save/1752328/zwf1tjdbw9.png)

主库将变更写binlog日志，然后从库连接到主库后，从库有一个I/O线程，将主库的binlog日志拷贝到本地，写入一个中继日志

接着从库中有一个SQL线程会从中继日志读取binlog，然后执行binlog日志中的内容

即在本地再次执行一遍SQL，确保跟主库的数据相同

- MySQL主从复制原理
![](https://ask.qcloudimg.com/http-save/1752328/k4urjnspih.png)

从库同步主库数据的过程是**串行化**的，即主库上并行的操作，在从库上会串行执行.

由于从库从主库拷贝日志以及串行执行SQL的特点，在高并发场景下是有延时的，从库数据一定会比主库慢一些，所以经常出现，刚写入主库的数据可能是读不到的，要过几十甚至几百ms才能读到

而且这里还有另外一个问题，若主库突然宕机，恰好数据还没同步到从库，那么有些数据可能在从库上是没有的，可能就这么丢失了

所以MySQL实际上在这有两个机制

## 半同步复制(semi-sync)

解决主库数据丢失问题

主库写入binlog日志后，就会强制此时立即将数据同步到从库

从库将日志写入自己本地的relay log后，会返回一个ack给主库

主库接收到至少一个从库的ack之后才会认为写操作完成

## 并行复制

解决主从同步延时问题

从库开启多个线程，并行读取relay log中不同库的日志，然后**并行重放不同库的日志**，这是**库级别的并行**

# 5 MySQL主从同步延时问题(核心)

- MySQL主从延迟导致的生产环境的问题
![](https://ask.qcloudimg.com/http-save/1752328/ear6wponaq.png)

```
show status，Seconds_Behind_Master
```

你可以看到从库复制主库的数据落后了多少ms

其实这块东西经常会碰到，就比如说用了MySQL主从架构后，可能会发现，刚写入库的数据结果没查到，结果就完蛋了

所以实际上你要考虑好应该在什么场景下来用这个MySQL主从同步

建议一般在读远远多于写，且读的时候一般对数据时效性要求没那么高的时候采用

所以我们可以考虑的就是，你可以用MySQL的并行复制，但问题是那是库级别的并行，所以有时候作用不是很大

此时,通常来说，我们会对于那种写后立马就要保证可以查到的场景，采用强制读主库的方式

确保你肯定可以读到数据。其实用一些数据库中间件也是没问题的。

一般若主从延迟较为严重

1. 分库 : 将一个主库拆分为4个主库，每个主库的写并发就500/s，此时主从延迟可忽略不计
2. 打开MySQL支持的并行复制，多个库并行复制，若某个库的写入并发特别高，写并发达到了2000/s，并行复制还是没意义。二八法则，很多时候比如说，就是少数的几个订单表，写入了2000/s，其他几十个表10/s
3. 重写代码 : 写代码的同学，要慎重，重写一下代码，插入数据之后，直接就更新，不要查询
4. 若确实存在必须先插入，立马要求就查询到，然后立马就要反过来执行一些操作，对这个查询设置**直连主库**(不推荐，这么搞导致读写分离的意义就丧失了)

# 参考

- 《Java工程师面试突击第1季-中华石杉老师》

# X 交流学习
![](https://img-blog.csdnimg.cn/20190504005601174.jpg)

## [Java交流群](https://jq.qq.com/?_wv=1027&k=5UB4P1T)
## [博客](http://www.shishusheng.com)

## [Github](https://github.com/Wasabi1234)
