# 1 面试题

分布式服务接口请求的顺序性如何保证？

# 2 考点分析

分布式系统接口的调用顺序,一般来说是不用保证的.

但是有时候可能确实需要**严格的顺序保证**.

举个例子:

服务 A 调用服务 B，先插入再删除。好，结果俩请求过去了，落在不同机器上，可能插入请求因为某些原因执行慢了一些，导致删除请求先执行了，此时因为没数据所以啥效果也没有；结果这个时候插入请求过来了，好，数据插入进去了，尴尬咯~

本该 “先插入 => 再删除”，这条数据应该没了，结果现在 “先删除 => 再插入”，数据还存在!

所以这都是分布式系统一些很常见的问题。

# 3 解决方案

一般来说,建议从业务逻辑上设计的系统最好是不需要这种顺序性的保证，因为一旦引入顺序性保障，比如使用**分布式锁**，会导致**系统复杂度上升**，而且会带来**效率低下**，**热点数据压力过大**等问题。

简单来说，首先你得用 Dubbo 的一致性 hash 负载均衡策略,将比如某一个订单 id 对应的请求都给分发到某个机器上去，接着就是在那个机器上因为可能还是多线程并发执行的，你可能得立即将某个订单 id 对应的请求扔一个**内存队列**里去，强制排队，来确保他们的顺序性

- 分布式系统接口调用顺序性图示
![](https://ask.qcloudimg.com/http-save/1752328/m3u86wst0u.png)

但是这样引发的后续问题就很多!

比如说要是某个订单对应的请求特别多，造成某台机器成**热点**怎么办？解决这些问题又要开启后续一连串的复杂技术方案......曾经这类问题弄的我们头疼不已，所以，还是建议什么呢？

最好是比如说刚才那种，一个订单的插入和删除操作，能不能合并成一个操作，就是一个删除，或者是什么，避免这种问题的产生。

# 参考

- 《Java工程师面试突击第1季-中华石杉老师》


# X 交流学习
![](https://img-blog.csdnimg.cn/20190504005601174.jpg)
## [Java交流群](https://jq.qq.com/?_wv=1027&k=5UB4P1T)
## [博客](http://www.shishusheng.com)
## [Github](https://github.com/Wasabi1234)