# 1 面试题

- dubbo支持哪些通信协议？
- 支持哪些序列化协议？

# 2 考点分析

在上一篇文章，我们说到dubbo的基本工作原理，那是你必须知道的，至少知道dubbo分成哪些层，然后平时怎么发起rpc请求的，注册、发现、调用，这些是最基本的。

接着就可以针对底层进行深入的讨伐了，比如第一步就可以先问问序列化协议这块，就是平时rpc的时候怎么走的？

# 3 面试题详解

## 3.1 dubbo支持的广阔通信协议

![](https://ask.qcloudimg.com/http-save/1752328/vd6y05p1i2.png)

### 3.1.1 dubbo协议

```
dubbo://192.168.0.1:20188
```

`默认`就是走dubbo协议的，单一长连接，NIO异步通信，基于hessian作为序列化协议

#### 适用场景

传输数据量很小（每次请求在100kb以内），但是并发量很高

为了要支持高并发场景，一般是服务提供者就几台机器，但是服务消费者有上百台，可能每天调用量达到上亿次！此时用长连接是最合适的，就是跟每个服务消费者维持一个长连接就可以，可能总共就100个连接。然后后面直接基于长连接NIO异步通信，可以支撑高并发请求。

否则如果上亿次请求每次都是短连接的话，服务提供者会扛不住。

而且因为走的是单一长连接，所以传输数据量太大的话，会导致并发能力降低。所以一般建议是传输数据量很小，支撑高并发访问。

### 3.1.2 rmi协议

走java二进制序列化，多个短连接，适合消费者和提供者数量差不多，适用于文件的传输，一般较少用

### 3.1.3 hessian协议

走hessian序列化协议，多个短连接，适用于提供者数量比消费者数量还多，适用于文件的传输，一般较少用

### 3.1.4 http协议

走json序列化

### 3.1.5 webservice

走SOAP文本序列化

## 3.2 dubbo支持的序列化协议

所以dubbo实际基于不同的通信协议，支持hessian、java二进制序列化、json、SOAP文本序列化多种序列化协议。但是hessian是其默认的序列化协议。

# 参考

《Java工程师面试突击第1季-中华石杉老师》

# X 交流学习
![](https://img-blog.csdnimg.cn/20190504005601174.jpg)
## [Java交流群](https://jq.qq.com/?_wv=1027&k=5UB4P1T)
## [博客](http://www.shishusheng.com)

## [Github](https://github.com/Wasabi1234)

