# 0 [Github](https://github.com/Wasabi1234)

# 面试题

Redis的持久化有哪几种方式？不同的持久化机制都有什么优缺点？持久化机制具体底层是如何实现的？

# 考点分析

Redis如果仅仅只是将数据缓存在内存里面，假若宕机了，再重启，内存里的数据就全部丢失了！

你必须得用Redis的持久化机制，将数据写入内存的同时，异步的慢慢的将数据写入磁盘

若Redis宕机了，重启启动，自动从磁盘上加载之前持久化的一些数据即可，也许会丢失少许数据，但至少不会将所有数据都弄丢 

针对的都是Redis的生产环境可能遇到的一些问题，就是Redis要是挂了再重启，内存里的数据不就全丢了？能不能重启的时候把数据给恢复了？

# 1 Redis持久化的意义

很多同学，自己也看过一些redis的资料和书籍，当然可能也看过一些redis视频课程

所有的资料，其实都会讲解redis持久化，但是有个问题，我到目前为止，没有看到有人很仔细的去讲解，redis的持久化意义

redis的持久化，RDB，AOF，区别，各自的特点是什么，适合什么场景

redis的企业级的持久化方案是什么，是用来跟哪些企业级的场景结合起来使用的？？？

redis持久化的意义，在于故障恢复

比如你部署了一个redis，作为cache缓存，当然也可以保存一些较为重要的数据

如果没有持久化的话，redis遇到灾难性故障的时候，就会丢失所有的数据

如果通过持久化将数据搞一份儿在磁盘上去，然后定期比如说同步和备份到一些云存储服务上去，那么就可以保证数据不丢失全部，还是可以恢复一部分数据回来的

![](https://ask.qcloudimg.com/http-save/1752328/yftp8qgfm9.png)

我们已经知道对于一个企业级的redis架构来说，持久化是不可减少的

企业级redis集群架构：海量数据、高并发、高可用

持久化主要是做灾难恢复，数据恢复，也可以归类到高可用的一个环节

比如你的Redis宕机，你要做的事情是让Redis变得可用，尽快变得可用!

重启Redis，尽快让它对外提供服务，但就如上一讲所述，若你没做数据备份处理，即使Redis启动了，数据都没了!可用什么呢?

很可能说，大量的请求过来，缓存全部无法命中，在Redis里根本找不到数据，这个时候就造成缓存雪崩，就会去MySQL数据库去找，突然MySQL承接高并发，宕机!

MySQL宕机，你都没法去找数据恢复到Redis里面去，Redis的数据从哪儿来？就是从MySQL来的!

> 具体的完整的缓存雪崩的场景，还有企业级的解决方案，到后面讲

若你把Redis的持久化做好，备份和恢复方案也做到，那么即使你的Redis故障，也可通过备份数据，快速恢复，一旦恢复立即对外提供服务

# 2 Redis的持久化机制

- RDB和AOF的介绍
![](https://ask.qcloudimg.com/http-save/1752328/yxna6xisjp.png)
- RDB持久化机制
对Redis中的数据执行周期性的持久化
- AOF机制
将每条写命令作为日志，以`append-only`模式写入一个日志文件，在Redis重启时，通过回放日志中的写入指令来重构整个数据

> 如果我们希望Redis仅作为纯内存的缓存来用，亦可禁止RDB和AOF等所有的持久化机制

通过RDB或AOF，都可以将Redis内存中的数据给持久化，然后可以再将这些数据备份到别的需要之地

若Redis宕机，服务器上的内存和磁盘上的数据都丢了，可以从云服务上拷贝回来之前的数据，放到指定的目录中，然后重启Redis，Redis会自动根据持久化数据文件中的数据，去恢复内存中的数据，继续对外提供服务

如果同时使用RDB和AOF两种持久化机制，那么在Redis重启时，会使用AOF来重新构建数据，因为AOF中的数据更加完整!

## 2.1 深入RDB

### 2.1.1 RDB的优点

- RDB会生成多个数据文件，每个数据文件都代表了某一个时刻Redis中的数据，这种多数据文件方式，**非常适合做冷备**，可以将这种完整的数据文件发送到某远程的安全存储，比如说Amazon的S3云服务上去，在国内可以是阿里云的ODPS分布式存储上，以预定好的备份策略来定期备份Redis中的数据
- RDB对Redis对外提供的读写服务，影响非常小，可以让rRedis保持高性能，因为Redis主进程只要fork一个子进程，让子进程执行RDB
- 相对于AOF持久化机制来说，直接基于RDB数据文件来重启和恢复Redis进程，更加快速

### 2.1.2 RDB的缺点

- 若想要在Redis故障时，尽可能少的丢失数据，那么RDB没有AOF好
一般来说，RDB数据快照文件，都是每隔5分钟，或者更长时间生成一次，若过程中Redis宕机，那么就会丢失最近未持久化的数据
- RDB每次在fork子进程来执行RDB快照数据文件生成的时候，如果数据文件特别大，可能会导致对客户端提供的服务暂停数毫秒，或者甚至数秒
- RDB丢失数据的问题![](https://ask.qcloudimg.com/http-save/1752328/jfb6d56yn7.png)

## 2.2 深入AOF

![](https://ask.qcloudimg.com/http-save/1752328/t59ew3muns.png)

- AOF rewrite原理剖析
![](https://ask.qcloudimg.com/http-save/1752328/nn2nks9rdo.png)

### 2.2.1 AOF的优点

- 更好的避免数据丢失
一般AOF会每隔1s，通过一个子进程执行一次fsync操作，最多丢失1s的数据
- append-only模式写入
所以没有任何磁盘寻址的开销，写入性能高，且文件不易破损，即使文件尾部破损，也易修复
- 日志文件即使过大，出现后台重写操作，也不会影响客户端的读写
因为在rewrite log时，会压缩其中的指令，创建出一份需要恢复数据的最小日志。在创建新日志时，旧日志文件还是照常写入。当新的merge后的日志文件准备好时，再交换新旧日志文件即可!
- 命令通过非常可读的方式记录
该特性非常适合做灾难性误删除操作的**紧急恢复**。
比如某人不小心用flushall命令清空了所有数据，只要这个时候后台rewrite还没有发生，可立即拷贝AOF文件，将最后一条flushall命令给删了，然后再将该AOF文件放回去，就可通过恢复机制，自动恢复所有数据

### 2.2.2 AOF的缺点

- 对于同一份数据，AOF日志一般比RDB快照更大
- AOF开启后，写QPS会比RDB的低，因为AOF一般会配置成每s fsync一次日志文件，当然，每s一次fsync，性能也还是很高的
- 以前AOF发生过bug，就是通过AOF记录的日志，进行数据恢复的时候，没有恢复一模一样的数据出来
类似AOF这种较为复杂的基于命令日志/merge/回放的方式，比基于RDB的每次持久化一份完整的数据快照方式相比更加脆弱一些，易产生bug
不过AOF就是为了避免rewrite过程导致的bug，因此每次rewrite并不是基于旧的指令日志进行merge的，而是基于当时内存中的数据进行指令的重新构建，这样健壮性会更好

# 3 抉择RDB & AOF

1. 不要仅使用RDB，因为那样会导致你丢失很多数据
2. 也不要仅使用AOF，因为那样有两个问题
2.1 你通过AOF做冷备，没有RDB做冷备，来的恢复速度更快
2.2 RDB每次简单粗暴生成数据快照，更加健壮，可以避免AOF这种复杂的备份和恢复机制的bug
3. 综合使用AOF和RDB
3.1 用AOF保证数据不丢失，作为数据恢复的第一选择
3.2 用RDB做不同程度的冷备，在AOF文件都丢失或损坏不可用时，还可使用RDB快速实现数据恢复

# 参考

《Java工程师面试突击第1季-中华石杉老师》

# X 交流学习
![](https://img-blog.csdnimg.cn/20190504005601174.jpg)
## [Java交流群](https://jq.qq.com/?_wv=1027&k=5UB4P1T)
## [博客](http://www.shishusheng.com)
## [Github](https://github.com/Wasabi1234)