# 1 面试题
如何保证消息队列不重复消费数据,即如何保证消息消费时的幂等性?

# 2 考点分析
消费消息，那肯定要考虑考虑会不会重复消费.
能不能避免重复消费,或者重复消费了也别造成系统异常可以嘛?

这个是MQ领域的基本问题，其实本质上还是问你使用消息队列如何保证幂等性，这个是你架构里要考虑的一个问题。

面试官问你，肯定是必问的，这是你要考虑的实际生产上的系统设计问题。

# 3 详解
先大概说一说可能会有哪些重复消费的问题。

首先就是比如rabbitmq、rocketmq、kafka，都有可能会出现消费重复消费的问题.
因为这问题通常不是mq自己保证的，是给你保证的.

我们挑一个kafka来举个例子，说说
## 3.1 如何重复消费
kafka实际上有个offset的概念，就是每个消息写进去，都有一个offset，代表他的序号，然后consumer消费数据之后，每隔一段时间，会把自己消费过的消息的offset提交一下，代表我已经消费过了，下次我要是重启啥的，你就让我继续从上次消费到的offset来继续消费吧.

但是凡事总有意外，有时候重启系统，看你怎么重启了，如果碰到点着急的，直接kill进程了，再重启。这会导致consumer有些消息处理了，但是没来得及提交offset
尴尬了!重启之后，少数消息会再次消费一次。

其实重复消费不可怕，可怕的是你没考虑到重复消费之后，怎么保证幂等性。

给你举个例子吧。假设你有个系统，消费一条往数据库里插入一条，要是你一个消息重复两次，你不就插入了两条，这数据不就错了？
但是你要是消费到第二次的时候，自己判断一下已经消费过了，直接扔了，不就保留了一条数据？

![](https://uploadfiles.nowcoder.com/files/20190625/5088755_1561445338875_20190625142648438.png)

一条数据重复出现两次，数据库里就只有一条数据，这就保证了系统的幂等性

> 幂等性，通俗点说，就一个数据，或者一个请求，给你重复来多次，你得确保对应的数据是不会改变的，不能出错。

那所以第二个问题来了
## 3.2 怎么保证消息队列消费的幂等性？
其实还是得结合业务来思考，这里给几个思路：
- 比如你拿个数据要写库，你先根据主键查一下，如果这数据都有了，你就别插入了，update一下好嘛
- 比如你是写redis，那没问题了，反正每次都是set，天然幂等性
- 比如你不是上面两个场景，那做的稍微复杂一点，你需要让生产者发送每条数据的时候，里面加一个全局唯一的id，类似订单id之类的东西，然后你消费后，先根据该id去比如redis里查询，之前消费过吗？
  - 未消费，就处理，然后将该id写redis
  - 已消费，就别处理了，保证不重复处理相同的消息即可。

还有比如基于数据库的唯一键来保证重复数据不会重复插入多条
> 拿到数据的时候，每次重启可能会有重复，因为kafka消费者还没来得及提交offset，重复数据拿到了以后我们插入的时候，因为有唯一键约束了，所以重复数据只会插入报错，不会导致数据库中出现脏数据


![](https://uploadfiles.nowcoder.com/files/20190625/5088755_1561445338863_20190625142719969.png)
如何保证MQ的消费是幂等性的，是需要结合具体的业务来看的

# 参考
《Java工程师面试突击第1季-中华石杉老师》


# X 交流学习
![](https://img-blog.csdnimg.cn/20190504005601174.jpg)
## [Java交流群](https://jq.qq.com/?_wv=1027&k=5UB4P1T)
## [博客](http://www.shishusheng.com)
## [Github](https://github.com/Wasabi1234)
