我们知道synchronized是重量级锁，效率不怎么样，不过在JDK6中对synchronize的实现进行了各种优化，使得它显得不是那么重了，那么JVM采用了那些优化手段呢
# 锁优化
如自旋锁、适应性自旋锁、锁消除、锁粗化、偏向锁、轻量级锁等技术来减少锁操作的开销。 
锁主要存在四种状态：无锁状态、偏向锁状态、轻量级锁状态、重量级锁状态
他们会随着竞争的激烈而逐渐升级。
注意锁可以升级不可降级，这种策略是为了提高获得锁和释放锁的效率
## 自旋锁
线程的阻塞和唤醒需要CPU从用户态转为核心态，频繁的阻塞和唤醒对CPU来说是一件负担很重的工作，势必会给系统的并发性能带来很大的压力。
同时我们发现在许多应用上面，对象锁的锁状态只会持续很短一段时间，为了这一段很短的时间频繁地阻塞和唤醒线程是非常不值得的。所以引入自旋锁。
 
所谓自旋锁，就是让该线程等待一段时间，不会被立即挂起，看持有锁的线程是否会很快释放锁。

怎么等待呢？执行一段无意义的循环即可（自旋）。
 
自旋等待不能替代阻塞，先不说对处理器数量的要求，虽然它可以避免线程切换带来的开销，但是它占用了处理器的时间。
如果持有锁的线程很快就释放了锁，那么自旋的效率就非常好，反之，自旋的线程就会白白消耗掉处理的资源，它不会做任何有意义的工作，典型的占着茅坑不拉屎，这样反而会带来性能上的浪费。
所以说，自旋等待的时间（自旋的次数）必须要有一个限度，如果自旋超过了定义的时间仍然没有获取到锁，则应该被挂起。 

自旋锁在JDK 1.4.2中引入，默认关闭，但是可以使用-XX:+UseSpinning开启，在JDK1.6中默认开启。同时自旋的默认次数为10次，可以通过参数-XX:PreBlockSpin来调整； 
如果通过参数-XX:preBlockSpin来调整自旋锁的自旋次数，会带来诸多不便。假如我将参数调整为10，但是系统很多线程都是等你刚刚退出的时候就释放了锁（假如你多自旋一两次就可以获取锁），你是不是很尴尬。于是JDK1.6引入自适应的自旋锁，让虚拟机会变得越来越聪明。
## 适应自旋锁
JDK 1.6引入了更加聪明的自旋锁，即自适应自旋锁。
所谓自适应就意味着自旋的次数不再是固定的，它由前一次在同一个锁上的自旋时间及锁的拥有者的状态来决定。

它怎么做呢？
线程如果自旋成功了，那么下次自旋的次数会更多，因为虚拟机认为既然上次成功了，那么此次自旋也很有可能会再次成功，那么它就会允许自旋等待持续的次数更多。反之，如果对于某个锁，很少有自旋能够成功的，那么在以后要或者这个锁的时候自旋的次数会减少甚至省略掉自旋过程，以免浪费处理器资源。 

有了自适应自旋锁，随着程序运行和性能监控信息的不断完善，虚拟机对程序锁的状况预测会越来越准确，虚拟机会变得越来越聪明。
## 锁消除
为了保证数据的完整性，我们在进行操作时需要对这部分操作进行同步控制，但是在有些情况下，JVM检测到不可能存在共享数据竞争，这时JVM会对这些同步锁进行锁消除。

锁消除的依据是逃逸分析的数据支持。
 
如果不存在竞争，为什么还需要加锁呢？所以锁消除可以节省毫无意义的请求锁的时间。
变量是否逃逸，对于虚拟机来说需要使用数据流分析来确定，但是对于我们程序员来说这还不清楚么？但有时候程序并不是我们所想的那样,我们虽然没有显示使用锁，但是我们在使用一些JDK的内置API时，如StringBuffer、Vector、HashTable等，这时候会存在隐形的加锁操作。比如StringBuffer的append()方法，Vector的add()方法

```
    public void vectorTest(){
        Vector<String> vector = new Vector<String>();
        for(int i = 0 ; i < 10 ; i++){
            vector.add(i + "");
        }

        System.out.println(vector);
    }
```
在运行这段代码时，JVM可以明显检测到变量vector没有逃逸出方法vectorTest()之外，所以JVM可以大胆地将vector内部的加锁操作消除。
## 锁粗化
我们知道在使用同步锁的时候，需要让同步块的作用范围尽可能小,即仅在共享数据的实际作用域中才进行同步，这样做的目的是为了使需要同步的操作数量尽可能小，如果存在锁竞争，那么等待锁的线程也能尽快拿到锁 

在大多数的情况下，上述观点是正确的，本人也一直坚持着这个观点。但是如果一系列的连续加锁解锁操作，可能会导致不必要的性能损耗，所以引入锁粗化的概念:
就是将多个连续的加锁、解锁操作连接在一起，扩展成一个范围更大的锁

如上面实例：vector每次add的时候都需要加锁操作，JVM检测到对同一个对象（vector）连续加锁、解锁操作，会合并一个更大范围的加锁、解锁操作，即加锁解锁操作会移到for循环外

## 轻量级锁
主要目的是在没有多线程竞争的前提下，减少传统的重量级锁使用OS的互斥量(mutex)产生的性能消耗。
当关闭偏向锁功能或者多个线程竞争偏向锁导致偏向锁升级为轻量级锁，则会尝试获取轻量级锁，其步骤如下： 
###**获取锁** 
1. 判断当前对象是否处于无锁状态（hashcode、0、01）
   - 是
JVM将首先在当前线程的栈帧中建立一个名为锁记录（Lock Record）的空间，用于存储锁对象目前的Mark Word的拷贝（官方把这份拷贝加了一个Displaced前缀，即Displaced Mark Word）
   - 否
执行3 
2. JVM利用CAS操作尝试将对象的Mark Word更新为指向Lock Record的指正
   - 成功(表示竞争到锁)
将锁标志位变成00（表示此对象处于轻量级锁状态），执行同步操作
   - 失败
执行3 
3. 判断当前对象的Mark Word是否指向当前线程的栈帧
   - 是(表示当前线程已经持有当前对象的锁)
直接执行同步代码块
   - 否(只能说明该锁对象已经被其他线程抢占)
轻量级锁需要膨胀为重量级锁，锁标志位变成10，后面等待的线程将会进入阻塞状态
###**释放锁** 
轻量级锁的释放也是通过CAS操作来进行的，主要步骤如下： 
1. 取出获取轻量级锁时保存在Displaced Mark Word中的数据 
2. 用CAS操作将取出的数据替换到当前对象的Mark Word中
   - 成功
说明释放锁成功
   - 失败
执行3 
3. CAS操作替换失败，说明有其他线程尝试获取该锁，则需要在释放锁的同时需要唤醒被挂起的线程

对于轻量级锁，其性能提升的依据是
"对于绝大部分的锁，在整个生命周期内都是不会存在竞争的"
如果打破这个依据则除了互斥的开销外，还有额外的CAS操作，因此在有多线程竞争的情况下，轻量级锁比重量级锁更慢

* * *

下图是轻量级锁的获取和释放过程 
![](http://upload-images.jianshu.io/upload_images/4685968-835dc27a4cab0094.png?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240)
## 偏向锁
目的：在无多线程竞争的情况下尽量减少不必要的轻量级锁执行路径。
上面提到了轻量级锁的加锁解锁操作是需要依赖多次CAS原子指令的。
那么偏向锁是如何来减少不必要的CAS操作呢？
我们可以查看Mark work的结构就明白了。
只需要检查是否为偏向锁、锁标识为以及ThreadID即可，处理流程如下： 
###**获取锁** 
1. 检测Mark Word是否为可偏向状态，即是否为偏向锁1，锁标识位为01 
2. 若为可偏向状态，则测试线程ID是否为当前线程ID
   - 是
执行5
   - 否
执行3 
3. 如果线程ID不为当前线程ID，则通过CAS操作竞争锁,竞争
   - 成功
将Mark Word的线程ID替换为当前线程ID，
   - 失败
执行4 
4. CAS竞争锁失败，证明当前存在多线程竞争情况，当到达全局安全点，获得偏向锁的线程被挂起，偏向锁升级为轻量级锁，然后被阻塞在安全点的线程继续往下执行同步代码块
5. 执行同步代码块
###**释放锁** 
偏向锁的释放采用了一种只有竞争才会释放锁的机制，线程是不会主动去释放偏向锁，需要等待其他线程来竞争。
偏向锁的撤销需要等待全局安全点（这个时间点是上没有正在执行的代码）。其步骤如下： 
1. 暂停拥有偏向锁的线程，判断锁对象石是否还处于被锁定状态
2. 撤销偏向锁，恢复到无锁状态（01）或者轻量级锁的状态

* * *

下图是偏向锁的获取和释放流程 
![](http://upload-images.jianshu.io/upload_images/4685968-15051bba71218318?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240)

## 重量级锁
重量级锁通过对象内部的监视器（monitor）实现，其中monitor的本质是依赖于底层操作系统的Mutex Lock实现，操作系统实现线程之间的切换需要从用户态到内核态的切换，切换成本非常高
