并发不一定要依赖多线程（如PHP的多进程并发），但在Java中谈论并发，大多数都与线程脱不开关系
# 线程的实现
线程是CPU调度的基本单位。

Thread类与大部分的Java API有显著的差别，它的所有关键方法都是声明为Native的。
意味着这个方法没有使用或无法使用平台无关的手段来实现。
# 内核线程(Kernel-Lever Thread,KLT)
直接由操作系统内核(Kermel,下称内核)支持的线程
由内核来完成线程切换，内核通过操纵调度器(Sheduler) 对线程进行调度，并负责将线程的任务映射到各个处理器上。
每个内核线程可以视为内核的一个分身,这样OS就有能力同时处理多件事情，支持多线程的内核就叫做多线程内核(Multi-Threads Kernel )。

程序一般不会直接去使用KLT，而使用KLT的一种高级接口即轻量级进程(Light Weight Process,LWP)，即我们通常意义上所讲的线程，由于每个LWP都由一个KLT支持，因此只有先支持KLT，才能有LWP。这1：1的关系称为`一对一的线程模型`。
![KLT与LWP之间1：1的关系](https://upload-images.jianshu.io/upload_images/4685968-497d1cfc86f6b084.png?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240)
- 局限性
由于是基于KLT实现的，所以各种线程操作，如创建、析构及同步，都需要进行系统调用。而系统调用的代价相对较高，需要在用户态和内核态中来回切换
其次，每个LWP都需要有一个KLT的支持，因此LWP要消耗一定的内核资源（如KLT的栈空间），因此一个系统支持LWP的数量是有限的
#用户线程
创建，切换和调度各种细节都需要考虑，实现及其困难，已被java、ruby等语言放弃
# 用户线程混合轻量级进程

# Java线程的实现
用户线程还是完全建立在用户空间中，因此用户线程的创建、切换、析构等操作依然廉价，并
且可以支持大规模的用户线程并发
操作系统提供支持的轻量级进程则作为用户线程和内核线程之间的桥梁，这样可以使用内核提供的线程调度功能及处理器映射，并且用户线程的系统调用要通过轻量级线程来完成，大大降低了整个进程被完全阻塞的风险。
在这种混合模式中，用户线程与轻量级进程的数量比是不定的，即为N :M 的关系
![用户线程与轮量级进程之间N :M 的关系](https://upload-images.jianshu.io/upload_images/4685968-b64e81020899c37e.png?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240)
许多UN1X 系列的操作系统，如Solaris、HP-UX 等都提供了N: M 的线程模型实现。
#.Java 线程
JDK 1.2 之前是基于称为“绿色线程”(Green-Threads )的用户线程实现
在JDK 1.2 中替换为基于操作系统原生线程模型来实现
因此，在目前的JDK 版本中，操作系统支持怎样的线程模型，在很大程度上决定了Java 虚拟机的线程是怎样映射的，这点在不同的平台上没有办法达成一致，虚拟机规范中也并未限定Java 线程需要使用哪种线程模型来实现。
线程模型只对线程的并发规模和操作成本产生影响，对Java 程序的编码和运行过程来说，这些差异都是透明的。
对于Siun JDK 来说，它的Windows 版与Linux版都是使用一对一的线程模型实现的，一条Java线程就映射到一条轻量级进程之中，因为Windows 和Linux系统提供的线程模型就是一对一的
而在Solaris 平台中，由于操作系统的线程特性可以同时支持一对一(通过Bound
Threaids或Alternate Libthread实现)及多对多( 通过LWP/Thread Based Synchronization
实现) 的线程模型，因此在Solaris 版的JDK 中也对应提供了两个平台专有的虚拟桃参数:
-XX:+UseLWPSynchronization （默认值) 和-XX:+UseBoyndThreads 来明确指定虚拟
机使用哪种线程模型。
# Java线程调度
- 线程调度
系统为线程分配处理器使用权的过程，主要调度方式有两种
  - 协同式线程调度(Cooperative Threads-Scheduling）
  - 抢占式线程调度(Preemptive Threads-Scheduling )

使用协同式调度的多线程系统，线程执行时间由线程本身控制，线程把自己工作执行完后，要主动通知系统切换到另外一个线程上。
协同式多线程
- 最大好处
实现简单，而且由于线程要把自己的事情干完后才进行线程切换,切换操作对线程白己是可知的，所以没有什么线程同步的问题
- 坏处也很明显
 线程执行时间不可控制

使用抢占式调度的多线程系统，那么每个线程将由系统来分配执行时间，线程的切换不由线程本身决定，在这种实现线程调度的方式下，线程执行时间系统可控的
Java使用的线程调度方式就是抢占式调度

虽然Java线程调度是系统自动完成的，但是我们还是可“建议”系统给某些线程多分配一点执行时间，可以通过设置线程优先级来完成。Java 语言一共设置了10个级别的线程优先级(Thread.MIN_PRIORITY 至Thread.MAX_PRIORITY )，在两个线程同时处于Ready 状态时，优先级越高的线程越容易被系统选择执行。

Java 的线程是通过映射到系统的原生线程上来实现的，所以线程调度最终还是取决于OS，虽然现在很多OS都提供线程优先级的概念，但是并不见得能与Java线程的优先级对应，如Solaris中有2147483648 (232 )种优先级，但Windows中就只有7种，比Java 线程优先级多的系统还好说，中间留下一点空位就可以了,但比Java线程优先级少的系统，就不得不出现几个优先级相同的情况了

不仅仅是说在一些平台上不同的优先级实际会变得相同这一点，还有其他情况让我们不能太依赖优先级:优先级可能会被系统自行改变。
例如，在Windows 系统中存在一个称为“优先级推进器”(Priority Boosting，当然它可以被
关闭掉) 的功能，它的大致作用就是当系统发现一个线程执行得特别“勤奋努力”的话，可能会越过线程优先级去为它分配执行时间。因此，我们不能在程序中通过优先级完全准确地判断一组状态都为Ready 的线程将会先执行哪一个
